CREATE DATABASE IF NOT EXISTS warung_madura;
USE warung_madura;

CREATE TABLE IF NOT EXISTS users (
  id_user INT AUTO_INCREMENT PRIMARY KEY,
  nama VARCHAR(100) NOT NULL,
  username VARCHAR(50) NOT NULL UNIQUE,
  password VARCHAR(255) NOT NULL,
  role ENUM('admin','kasir') NOT NULL DEFAULT 'kasir'
);

CREATE TABLE IF NOT EXISTS barang (
  id_barang INT AUTO_INCREMENT PRIMARY KEY,
  nama_barang VARCHAR(150) NOT NULL,
  harga INT NOT NULL DEFAULT 0,
  stok INT NOT NULL DEFAULT 0
);

CREATE TABLE IF NOT EXISTS transaksi (
  id_transaksi INT AUTO_INCREMENT PRIMARY KEY,
  tanggal DATETIME NOT NULL,
  id_user INT NOT NULL,
  total INT NOT NULL,
  FOREIGN KEY (id_user) REFERENCES users(id_user) ON DELETE RESTRICT
);

CREATE TABLE IF NOT EXISTS detail_transaksi (
  id_detail INT AUTO_INCREMENT PRIMARY KEY,
  id_transaksi INT NOT NULL,
  id_barang INT NOT NULL,
  qty INT NOT NULL,
  subtotal INT NOT NULL,
  FOREIGN KEY (id_transaksi) REFERENCES transaksi(id_transaksi) ON DELETE CASCADE,
  FOREIGN KEY (id_barang) REFERENCES barang(id_barang) ON DELETE RESTRICT
);

-- password: admin123
INSERT INTO users (nama, username, password, role) VALUES
('Administrator','admin','$2b$12$82FqfV5/rhZ7GJJXzeNhlufSisrZ2is7HqxXJNlcEPiz0WlX/awqC','admin');

INSERT INTO barang (nama_barang, harga, stok) VALUES
('Beras 5kg', 60000, 10),
('Gula 1kg', 15000, 20),
('Minyak Goreng 1L', 20000, 15),
('Sabun Mandi', 5000, 30);

USE warung_madura;

ALTER TABLE users 
MODIFY role ENUM('admin','kasir','pelanggan') 
NOT NULL DEFAULT 'pelanggan';

CREATE TABLE IF NOT EXISTS pelanggan (
  id_pelanggan INT AUTO_INCREMENT PRIMARY KEY,
  id_user INT NOT NULL,
  alamat TEXT,
  no_hp VARCHAR(20),
  FOREIGN KEY (id_user) REFERENCES users(id_user) ON DELETE CASCADE
);

CREATE TABLE IF NOT EXISTS pesanan_online (
  id_pesanan INT AUTO_INCREMENT PRIMARY KEY,
  tanggal DATETIME NOT NULL,
  id_pelanggan INT NOT NULL,
  total INT NOT NULL,
  status ENUM('menunggu','diproses','dikirim','selesai') DEFAULT 'menunggu',
  FOREIGN KEY (id_pelanggan) REFERENCES pelanggan(id_pelanggan)
);

CREATE TABLE IF NOT EXISTS detail_pesanan (
  id_detail INT AUTO_INCREMENT PRIMARY KEY,
  id_pesanan INT NOT NULL,
  id_barang INT NOT NULL,
  qty INT NOT NULL,
  subtotal INT NOT NULL,
  FOREIGN KEY (id_pesanan) REFERENCES pesanan_online(id_pesanan) ON DELETE CASCADE,
  FOREIGN KEY (id_barang) REFERENCES barang(id_barang) ON DELETE RESTRICT
);

-- password: kasir123
INSERT INTO users (nama, username, password, role) VALUES
('Kasir 1','kasir1','$2b$12$e0MYzXyjpJS7Pd0RVvHwHeFxzEw8dDqUe1koRaSPoaqe7iKz8E7W6','kasir');

-- password: pelanggan123
INSERT INTO users (nama, username, password, role) VALUES
('Pelanggan 1','pelanggan1','$2b$12$1u7HkNQv6qfZ3k6sYtP6VeYz0h6aJ6n6FQ2pE3Z6BzN5J2x0Qe4M6','pelanggan');

INSERT INTO pelanggan (id_user, alamat, no_hp) VALUES
(
  (SELECT id_user FROM users WHERE username='pelanggan1'),
  'Jl. Raya Madura No. 10',
  '081234567890'
);
USE warung_madura;

ALTER TABLE users 
MODIFY role ENUM('admin','kasir','pelanggan') 
NOT NULL DEFAULT 'pelanggan';

CREATE TABLE IF NOT EXISTS pelanggan (
  id_pelanggan INT AUTO_INCREMENT PRIMARY KEY,
  id_user INT NOT NULL,
  alamat TEXT,
  no_hp VARCHAR(20),
  FOREIGN KEY (id_user) REFERENCES users(id_user) ON DELETE CASCADE
);

CREATE TABLE IF NOT EXISTS pesanan_online (
  id_pesanan INT AUTO_INCREMENT PRIMARY KEY,
  tanggal DATETIME NOT NULL,
  id_pelanggan INT NOT NULL,
  total INT NOT NULL,
  status ENUM('menunggu','diproses','dikirim','selesai') DEFAULT 'menunggu',
  FOREIGN KEY (id_pelanggan) REFERENCES pelanggan(id_pelanggan)
);

CREATE TABLE IF NOT EXISTS detail_pesanan (
  id_detail INT AUTO_INCREMENT PRIMARY KEY,
  id_pesanan INT NOT NULL,
  id_barang INT NOT NULL,
  qty INT NOT NULL,
  subtotal INT NOT NULL,
  FOREIGN KEY (id_pesanan) REFERENCES pesanan_online(id_pesanan) ON DELETE CASCADE,
  FOREIGN KEY (id_barang) REFERENCES barang(id_barang) ON DELETE RESTRICT
);

-- password: kasir123
INSERT INTO users (nama, username, password, role) VALUES
('Kasir 1','kasir1','$2b$12$e0MYzXyjpJS7Pd0RVvHwHeFxzEw8dDqUe1koRaSPoaqe7iKz8E7W6','kasir');

-- password: pelanggan123
INSERT INTO users (nama, username, password, role) VALUES
('Pelanggan 1','pelanggan1','$2b$12$1u7HkNQv6qfZ3k6sYtP6VeYz0h6aJ6n6FQ2pE3Z6BzN5J2x0Qe4M6','pelanggan');

INSERT INTO pelanggan (id_user, alamat, no_hp) VALUES
(
  (SELECT id_user FROM users WHERE username='pelanggan1'),
  'Jl. Raya Madura No. 10',
  '081234567890'
);